unit MySysUtl;

{ === MySysUtl unit ===}
// A very small subset of the SysUtils unit from Delphi
{Author(s): N.M. Ismail (11/16/97)                             }
{Version: See =History= below.                                 }
{Description: This is a VERY small subset of utilities from    }
{   the Delphi SysUtils unit.                                  }
{Usage: Use these functions just like the ones in the SysUtils }
{   unit.                                                      }

{ === History === }
{  Date    |  Author      | Version | Notes                    }
{ 11/16/97 | N.M. Ismail  |  1.01d  | Created small subset of  }
{          |              |         | utils from SysUtils unit.}
{ 1/26/98  | J. Crawford  |  1.1    | Better docs.             }

{ === Notes === }
{ The MySysUtl unit has been created to shrink the size of the }
{ generated DLLs by at least 18k.  The only functions needed   }
{ were two PChar fuctions; namely StrLen and StrCat.           }

interface

uses
    Windows;

function  StrLen(Str :PChar):Cardinal; assembler;
function  StrCat(Dest, Source :PChar) :PChar;

implementation

function StrLen(Str :PChar) :Cardinal; assembler;
asm
  MOV     EDX,EDI
  MOV     EDI,EAX
  MOV     ECX,0FFFFFFFFH
  XOR     AL,AL
  REPNE   SCASB
  MOV     EAX,0FFFFFFFEH
  SUB     EAX,ECX
  MOV     EDI,EDX
end;

function StrEnd(Str :PChar) :PChar; assembler;
asm
  MOV     EDX,EDI
  MOV     EDI,EAX
  MOV     ECX,0FFFFFFFFH
  XOR     AL,AL
  REPNE   SCASB
  LEA     EAX,[EDI-1]
  MOV     EDI,EDX
end;

function StrCopy(Dest, Source :PChar) :PChar; assembler;
asm
  PUSH    EDI
  PUSH    ESI
  MOV     ESI,EAX
  MOV     EDI,EDX
  MOV     ECX,0FFFFFFFFH
  XOR     AL,AL
  REPNE   SCASB
  NOT     ECX
  MOV     EDI,ESI
  MOV     ESI,EDX
  MOV     EDX,ECX
  MOV     EAX,EDI
  SHR     ECX,2
  REP     MOVSD
  MOV     ECX,EDX
  AND     ECX,3
  REP     MOVSB
  POP     ESI
  POP     EDI
end;

function StrCat(Dest, Source :PChar) :PChar;
begin
  StrCopy(StrEnd(Dest), Source);
  Result := Dest;
end;

end.
